<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Navigation Menu with Dropdown</title>
    <style>
        /* CSS styling */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        header {
            background-color: #333;
            color: #fff;
            padding: 10px 0;
            text-align: center;
        }
        nav {
            background-color: #666;
            color: #fff;
            padding: 10px;
            text-align: center;
        }
        nav ul {
            list-style-type: none;
            padding: 0;
            margin: 0;
            display: flex;
            justify-content: center;
        }
        nav ul li {
            margin: 0 10px;
            position: relative;
        }
        nav ul li a {
            color: #fff;
            text-decoration: none;
            padding: 10px 15px;
            display: block;
        }
        nav ul li ul {
            display: none;
            position: absolute;
            top: 100%;
            left: 0;
            background-color: #666;
            padding: 0;
        }
        nav ul li:hover ul {
            display: block;
        }
        nav ul li ul li {
            width: 100%;
        }
        nav ul li ul li a {
            padding: 10px 15px;
        }
    </style>
</head>
<body>
    <header>
        <h1>Navigation Menu with Dropdown</h1>
    </header>
    <nav>
        <ul>
            <li><a href="#">Home</a></li>
            <li>
                <a href="#">About</a>
                <ul>
                    <li><a href="#">History</a></li>
                    <li><a href="#">Vision</a></li>
                    <li><a href="#">Mission</a></li>
                </ul>
            </li>
            <li><a href="#">Services</a></li>
            <li>
                <a href="#">Programs</a>
                <ul>
                    <li><a href="#">Program A</a></li>
                    <li><a href="#">Program B</a></li>
                    <li><a href="#">Program C</a></li>
                </ul>
            </li>
            <li><a href="#">Contact</a></li>
        </ul>
    </nav>
</body>
</html>
