<?php
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $apiKey = $_POST['apiKey'];
    $projectId = $_POST['projectId'];
    $fcmToken = $_POST['fcmToken'];
    $title = $_POST['title'];
    $body = $_POST['body'];
    $key1 = $_POST['key1'];
    $value1 = $_POST['value1'];
    $key2 = $_POST['key2'];
    $value2 = $_POST['value2'];

    function getAccessToken($apiKey) {
        $url = 'https://www.googleapis.com/oauth2/v4/token';
        $postFields = 'grant_type=client_credentials&client_id=' . $apiKey . '&client_secret=' . $apiKey;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $result = curl_exec($ch);
        if ($result === FALSE) {
            die('Curl failed: ' . curl_error($ch));
        }
        curl_close($ch);

        $json = json_decode($result, true);
        return $json['access_token'];
    }

    function sendPushNotification($projectId, $accessToken, $message) {
        $url = 'https://fcm.googleapis.com/v1/projects/' . $projectId . '/messages:send';

        $fields = [
            'message' => [
                'token' => $message['token'],
                'notification' => [
                    'title' => $message['title'],
                    'body' => $message['body']
                ],
                'data' => $message['data']
            ]
        ];

        $headers = [
            'Authorization: Bearer ' . $accessToken,
            'Content-Type: application/json'
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        $result = curl_exec($ch);
        if ($result === FALSE) {
            die('Curl failed: ' . curl_error($ch));
        }
        curl_close($ch);

        return $result;
    }

    $accessToken = getAccessToken($apiKey);

    $message = [
        'token' => $fcmToken,
        'title' => $title,
        'body' => $body,
        'data' => [$key1 => $value1, $key2 => $value2]
    ];

    $response = sendPushNotification($projectId, $accessToken, $message);
    echo $response;
}
?>
